#!/bin/bash
#
# Created by Tyler "-z-" Mulligan to build the version number for Nexuiz
# in the menu.  Released under the GPLv2
#
# Usage: pass a string to be converted to an image
#
# ./append 2.5.1
#
# _ = space
# s = svn
# z = z0rz (just for fun :-P)

# build the image out of the string for the version
function build_version {
	version=$1
	imagified=$(echo $version | sed 's/\(.\)/vfont_\1.tga /g' | sed 's/s/svn/;s/_\./_dot/g;s/__/_nbsp/g;s/z/z0rz/g' )
	convert $imagified +append version_number.tga
}

# place the image string on the big image
function place_on_bg {
	convert background_25.tga -page +259+41 version_number.tga -flatten background.tga
	convert background_ingame_25.tga -page +259+41 version_number.tga -flatten background_ingame.tga
}

# test case
#build_version 2.4_sz

build_version $1

place_on_bg
