#ifdef INTERFACE
CLASS(NexuizShaggySelectDialog) EXTENDS(NexuizRootDialog)
	METHOD(NexuizShaggySelectDialog, fill, void(entity))  // to be overridden by user to fill the dialog with controls
	ATTRIB(NexuizShaggySelectDialog, title, string, strzone(cvar_string("msb_name")))  // name of the pop up
	ATTRIB(NexuizShaggySelectDialog, color, vector, stov(cvar_string("msb_colour")))  // 'R G B' range 0 - 1
	ATTRIB(NexuizShaggySelectDialog, intendedWidth, float, cvar("msb_width"))  // width of the pop up 0 - 1
	ATTRIB(NexuizShaggySelectDialog, intendedHeight, float, cvar("msb_height"))  // height of the pop up 0 - 1
	ATTRIB(NexuizShaggySelectDialog, rows, float, cvar("msb_rows"))  // number of rows
	ATTRIB(NexuizShaggySelectDialog, columns, float, cvar("msb_columns"))  // number of columns
	ATTRIB(NexuizShaggySelectDialog, name, string, "ShaggySelect")  // name used to call the pop up
ENDCLASS(NexuizShaggySelectDialog)

float msb_width(string);
string msb_label(string);
vector msb_colour(string);
string msb_action(string);
#endif

#ifdef IMPLEMENTATION
entity makeShaggyButton(string theName, vector theColor, string commandtheName)
{
	entity b;
	b = makeNexuizCommandButton(theName, theColor, commandtheName, 1);
	return b;
}

void fillNexuizShaggySelectDialog(entity me)
{
	me.TR(me);
		if (msb_width("0") > 0)
			me.TD(me, 1, msb_width("0"), makeShaggyButton(msb_label("0"), msb_colour("0"), msb_action("0")));
		if (msb_width("1") > 0)
			me.TD(me, 1, msb_width("1"), makeShaggyButton(msb_label("1"), msb_colour("1"), msb_action("1")));
		if (msb_width("2") > 0)
			me.TD(me, 1, msb_width("2"), makeShaggyButton(msb_label("2"), msb_colour("2"), msb_action("2")));
	me.TR(me);
		if (msb_width("3") > 0)
			me.TD(me, 1, msb_width("3"), makeShaggyButton(msb_label("3"), msb_colour("3"), msb_action("3")));
		if (msb_width("4") > 0)
			me.TD(me, 1, msb_width("4"), makeShaggyButton(msb_label("4"), msb_colour("4"), msb_action("4")));
		if (msb_width("5") > 0)
			me.TD(me, 1, msb_width("5"), makeShaggyButton(msb_label("5"), msb_colour("5"), msb_action("5")));
	me.TR(me);
		if (msb_width("6") > 0)
			me.TD(me, 1, msb_width("6"), makeShaggyButton(msb_label("6"), msb_colour("6"), msb_action("6")));
		if (msb_width("7") > 0)
			me.TD(me, 1, msb_width("7"), makeShaggyButton(msb_label("7"), msb_colour("7"), msb_action("7")));
		if (msb_width("8") > 0)
			me.TD(me, 1, msb_width("8"), makeShaggyButton(msb_label("8"), msb_colour("8"), msb_action("8")));
	me.TR(me);
		if (msb_width("9") > 0)
			me.TD(me, 1, msb_width("9"), makeShaggyButton(msb_label("9"), msb_colour("9"), msb_action("9")));
		if (msb_width("10") > 0)
			me.TD(me, 1, msb_width("10"), makeShaggyButton(msb_label("10"), msb_colour("10"), msb_action("10")));
		if (msb_width("11") > 0)
			me.TD(me, 1, msb_width("11"), makeShaggyButton(msb_label("11"), msb_colour("11"), msb_action("11")));
	me.TR(me);
		if (msb_width("12") > 0)
			me.TD(me, 1, msb_width("12"), makeShaggyButton(msb_label("12"), msb_colour("12"), msb_action("12")));
		if (msb_width("13") > 0)
			me.TD(me, 1, msb_width("13"), makeShaggyButton(msb_label("13"), msb_colour("13"), msb_action("13")));
		if (msb_width("14") > 0)
			me.TD(me, 1, msb_width("14"), makeShaggyButton(msb_label("14"), msb_colour("14"), msb_action("14")));
	me.TR(me);
		if (msb_width("15") > 0)
			me.TD(me, 1, msb_width("15"), makeShaggyButton(msb_label("15"), msb_colour("15"), msb_action("15")));
		if (msb_width("16") > 0)
			me.TD(me, 1, msb_width("16"), makeShaggyButton(msb_label("16"), msb_colour("16"), msb_action("16")));
		if (msb_width("17") > 0)
			me.TD(me, 1, msb_width("17"), makeShaggyButton(msb_label("17"), msb_colour("17"), msb_action("17")));
	me.TR(me);
}

float msb_width(string btn)
{
	return cvar(strcat("msb_width", btn));
}

string msb_label(string btn)
{
	return strzone(cvar_string((strcat("msb_label", btn))));
}

vector msb_colour(string btn)
{
	return stov(cvar_string(strcat("msb_colour", btn)));
}

string msb_action(string btn)
{
	return strzone(cvar_string((strcat("msb_action", btn))));
}
#endif

// click. The C-word so you can grep for it.