<?php
/**
 * MyGallery
 * http://www.mybbsource.com
 * 
 * By Alexandru21
 * */

if(!defined("IN_MYBB")) {
    die("This file cannot be accessed directly!");
}

function mygal_info() {
    return array(
        "name"				=> "MyGallery",
        "description"		=> "This plugin is a photo gallery.",
        "website"			=> "http://www.mybbsource.com",
        "author"			=> "Alexandru21",
        "authorsite"		=> "http://www.mybbsource.com",
        "version"			=> "7.0 Beta"
    );
}

function mygal_install() {
	global $db;
	$mygal = array(
		'gid'			=> 'NULL',
		'name'			=> 'mygal',
		'title'			=> 'MyGallery',
		'description'	=> 'The settings for MyGallery.',
		'disporder'		=> '1',
		'isdefault'		=> 'no',
	);

	$db->insert_query('settinggroups', $mygal);
	$gid = $db->insert_id();

	$mygal_setting_1 = array(
		'sid'			=> 'NULL',
		'name'			=> 'enablemygal',
		'title'			=> 'Enable MyGallery',
		'description'	=> 'If is set to no, the gallery will closed (it will not be closed for Administrators).',
		'optionscode'	=> 'yesno',
		'value'			=> 'yes',
		'disporder'		=> 1,
		'gid'			=> intval($gid),
	);

	$mygal_setting_2 = array(
		'sid'			=> 'NULL',
		'name'			=> 'mygal_pics',
		'title'			=> 'The users are able to add pictures?',
		'description'	=> 'If is set to no, the users will not be able to add pictures (the Administrators are able to add pictures).',
		'optionscode'	=> 'yesno',
		'value'			=> 'yes',
		'disporder'		=> 2,
		'gid'			=> intval($gid),
	);

	$mygal_setting_3 = array(
		'sid'			=> 'NULL',
		'name'			=> 'mygal_name',
		'title'			=> 'Gallery Name',
		'description'	=> 'Type here the name.',
		'optionscode'	=> 'text',
		'value'			=> 'MyGallery',
		'disporder'		=> 3,
		'gid'			=> intval($gid),
	);


	$mygal_setting_4= array(
		'sid'			=> 'NULL',
		'name'			=> 'mygal_restrict',
		'title'			=> 'CANT view the gallery:',
		'description'	=> 'Type here the usergroup&lsquo;s ID.',
		'optionscode'	=> 'text',
		'value'			=> 'NONE',
		'disporder'		=> 4,
		'gid'			=> intval($gid),
	);

	$mygal_setting_5= array(
		'sid'			=> 'NULL',
		'name'			=> 'mygal_admin',
		'title'			=> 'Who is the Administrator?',
		'description'	=> 'Type here the usergroup&lsquo;s ID. Sepparate by comma.',
		'optionscode'	=> 'text',
		'value'			=> '4',
		'disporder'		=> 5,
		'gid'			=> intval($gid),
	);

	$mygal_setting_6= array(
		'sid'			=> 'NULL',
		'name'			=> 'mygal_h',
		'title'			=> 'The height of the pictures (in category view mode)',
		'description'	=> 'Type here the value in pixels.',
		'optionscode'	=> 'text',
		'value'			=> '50',
		'disporder'		=> 6,
		'gid'			=> intval($gid),
	);

	$mygal_setting_7= array(
		'sid'			=> 'NULL',
		'name'			=> 'mygal_w',
		'title'			=> 'The weight of the pictures (in category view mode)',
		'description'	=> 'Type here the value in pixels.',
		'optionscode'	=> 'text',
		'value'			=> '50',
		'disporder'		=> 7,
		'gid'			=> intval($gid),
	);

	$mygal_setting_8= array(
		'sid'			=> 'NULL',
		'name'			=> 'mygal_order',
		'title'			=> 'The pictures will be ordered by:',
		'description'	=> 'Select',
		'optionscode'	=> 'select\nid=ID\nname=Name',
		'value'			=> 'id',
		'disporder'		=> 8,
		'gid'			=> intval($gid),
	);

	$mygal_setting_9= array(
		'sid'			=> 'NULL',
		'name'			=> 'mygal_order2',
		'title'			=> 'The pictures will be ordered ascending or descending?',
		'description'	=> 'Select',
		'optionscode'	=> 'select\nASC=Ascending\nDESC=Descending',
		'value'			=> 'ASC',
		'disporder'		=> 9,
		'gid'			=> intval($gid),
	);

	$mygal_setting_10= array(
		'sid'			=> 'NULL',
		'name'			=> 'mygal_order3',
		'title'			=> 'The categories will be ordered by:',
		'description'	=> 'Select',
		'optionscode'	=> 'select\nid=ID\nname=Name',
		'value'			=> 'id',
		'disporder'		=> 10,
		'gid'			=> intval($gid),
	);

	$mygal_setting_11= array(
		'sid'			=> 'NULL',
		'name'			=> 'mygal_order4',
		'title'			=> 'The categories will be ordered ascending or descending?',
		'description'	=> 'Select',
		'optionscode'	=> 'select\nASC=Ascending\nDESC=Descending',
		'value'			=> 'ASC',
		'disporder'		=> 11,
		'gid'			=> intval($gid),
	);

	$mygal_setting_12= array(
		'sid'			=> 'NULL',
		'name'			=> 'mygal_order5',
		'title'			=> 'The comments will be ordered ascending or descending?',
		'description'	=> 'Select',
		'optionscode'	=> 'select\nDESC=Descending\nASC=Ascending',
		'value'			=> 'ASC',
		'disporder'		=> 12,
		'gid'			=> intval($gid),
	);


	$mygal_setting_13= array(
		'sid'			=> 'NULL',
		'name'			=> 'mygal_upload',
		'title'			=> 'The pictures will be uploaded from:',
		'description'	=> 'Select',
		'optionscode'	=> 'select\nCOMPUTER=Computer\nURL=URL',
		'value'			=> 'COMPUTER',
		'disporder'		=> 13,
		'gid'			=> intval($gid),
	);

	$mygal_setting_14= array(
		'sid'			=> 'NULL',
		'name'			=> 'mygal_mycode',
		'title'			=> 'Enable MyCode, Smilies and Bad Words Filter for comments and descriptions?',
		'description'	=> 'Yes or No?',
		'optionscode'	=> 'yesno',
		'value'			=> 'yes',
		'disporder'		=> 14,
		'gid'			=> intval($gid),
	);


	$mygal_setting_15= array(
		'sid'			=> 'NULL',
		'name'			=> 'mygal_size',
		'title'			=> 'Maximum picture size (in KB)',
		'description'	=> 'If the pictures are uploaded from COMPUTER.',
		'optionscode'	=> 'text',
		'value'			=> '1024',
		'disporder'		=> 15,
		'gid'			=> intval($gid),
	);

	$mygal_setting_16= array(
		'sid'			=> 'NULL',
		'name'			=> 'mygal_page_pic',
		'title'			=> 'How many pictures per page?',
		'description'	=> 'Select',
		'optionscode'	=> 'select\n5=5\n10=10\n15=15\n20=20\n25=25\n50=50\n100=100',
		'value'			=> '15',
		'disporder'		=> 16,
		'gid'			=> intval($gid),
	);

	$mygal_setting_17= array(
		'sid'			=> 'NULL',
		'name'			=> 'mygal_page_cat',
		'title'			=> 'How many categories per page?',
		'description'	=> 'Select',
		'optionscode'	=> 'select\n5=5\n10=10\n15=15\n20=20\n25=25\n50=50\n100=100',
		'value'			=> '5',
		'disporder'		=> 17,
		'gid'			=> intval($gid),
	);

	$mygal_setting_18= array(
		'sid'			=> 'NULL',
		'name'			=> 'mygal_page_comment',
		'title'			=> 'How many comments per page?',
		'description'	=> 'Select',
		'optionscode'	=> 'select\n5=5\n10=10\n15=15\n20=20\n25=25\n50=50\n100=100',
		'value'			=> '20',
		'disporder'		=> 18,
		'gid'			=> intval($gid),
	);

	$mygal_setting_19= array(
		'sid'			=> 'NULL',
		'name'			=> 'mygal_guests',
		'title'			=> 'The guests are able to see the gallery?',
		'description'	=> 'Yes or No?',
		'optionscode'	=> 'yesno',
		'value'			=> 'yes',
		'disporder'		=> 19,
		'gid'			=> intval($gid),
	);

	$mygal_setting_20= array(
		'sid'			=> 'NULL',
		'name'			=> 'mygal_post',
		'title'			=> 'The guests are able to post comments?',
		'description'	=> 'Yes or No?',
		'optionscode'	=> 'yesno',
		'value'			=> 'yes',
		'disporder'		=> 20,
		'gid'			=> intval($gid),
	);

	$mygal_setting_21= array(
		'sid'			=> 'NULL',
		'name'			=> 'mygal_classic',
		'title'			=> 'Display images in classic mode?',
		'description'	=> 'Yes or No?',
		'optionscode'	=> 'yesno',
		'value'			=> 'no',
		'disporder'		=> 21,
		'gid'			=> intval($gid),
	);

	$mygal_setting_22= array(
		'sid'			=> 'NULL',
		'name'			=> 'mygal_title',
		'title'			=> 'Maximum characters for title in image view mode.',
		'description'	=> 'Type here the value',
		'optionscode'	=> 'text',
		'value'			=> '15',
		'disporder'		=> 22,
		'gid'			=> intval($gid),
	);

	$mygal_setting_23= array(
		'sid'			=> 'NULL',
		'name'			=> 'mygal_desc',
		'title'			=> 'Maximum characters for description in image view mode in classic mode.',
		'description'	=> 'Type here the value',
		'optionscode'	=> 'text',
		'value'			=> '15',
		'disporder'		=> 23,
		'gid'			=> intval($gid),
	);



	$db->insert_query('settings', $mygal_setting_1);
	$db->insert_query('settings', $mygal_setting_2);
	$db->insert_query('settings', $mygal_setting_3);
	$db->insert_query('settings', $mygal_setting_4);
	$db->insert_query('settings', $mygal_setting_5);
	$db->insert_query('settings', $mygal_setting_6);
	$db->insert_query('settings', $mygal_setting_7);
	$db->insert_query('settings', $mygal_setting_8);
	$db->insert_query('settings', $mygal_setting_9);
	$db->insert_query('settings', $mygal_setting_10);
	$db->insert_query('settings', $mygal_setting_11);
	$db->insert_query('settings', $mygal_setting_12);
	$db->insert_query('settings', $mygal_setting_13);
	$db->insert_query('settings', $mygal_setting_14);
	$db->insert_query('settings', $mygal_setting_15);
	$db->insert_query('settings', $mygal_setting_16);
	$db->insert_query('settings', $mygal_setting_17);
	$db->insert_query('settings', $mygal_setting_18);
	$db->insert_query('settings', $mygal_setting_19);
	$db->insert_query('settings', $mygal_setting_20);
	$db->insert_query('settings', $mygal_setting_21);
	$db->insert_query('settings', $mygal_setting_22);
	$db->insert_query('settings', $mygal_setting_23);

	rebuild_settings();

	$db->query("CREATE TABLE `".TABLE_PREFIX."gallery_photos` (
`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
`cat` INT NOT NULL ,
`name` TEXT NOT NULL ,
`uid` TEXT NOT NULL ,
`url` TEXT NOT NULL ,
`total_ratings` TEXT NOT NULL ,
`description` TEXT NOT NULL
) ");

$db->query("CREATE TABLE `".TABLE_PREFIX."gallery_comments` (
`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
`cat` INT NOT NULL ,
`pic` TEXT NOT NULL ,
`uid` TEXT NOT NULL ,
`message` TEXT NOT NULL
) ");

$db->query("CREATE TABLE `".TABLE_PREFIX."gallery_cats` (
`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
`name` TEXT NOT NULL ,
`description` TEXT NOT NULL
) ");

$db->query("CREATE TABLE `".TABLE_PREFIX."gallery_ratings` (
`id` INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
`pic` TEXT NOT NULL ,
`uid` TEXT NOT NULL ,
`rating` TEXT NOT NULL
) ");




}
function mygal_is_installed() {
	global $db;
	$query = $db->query("SELECT gid FROM ".TABLE_PREFIX."settinggroups WHERE name='mygal'");
	$gid = $db->fetch_field($query, "gid");

	if($gid)
   	{
		return true;
 	}
	return false;
 }

function mygal_activate() {
	require MYBB_ROOT."/inc/adminfunctions_templates.php";
	find_replace_templatesets('header', '#'.preg_quote('<li><a href="{$mybb->settings[\'bburl\']}/search.php"><img src="{$mybb->settings[\'bburl\']}/{$theme[\'imgdir\']}/toplinks/search.gif" alt="" title="" />{$lang->toplinks_search}</a></li>').'#', "<li><a href=\"mygal.php\"><img src=\"{\$mybb->settings['bburl']}/{\$theme['imgdir']}/icons/photo.gif\" alt=\"\" title=\"\" />{\$mybb->settings[mygal_name]}</a></li>\n					<li><a href=\"{\$mybb->settings['bburl']}/search.php\"><img src=\"{\$mybb->settings['bburl']}/{\$theme['imgdir']}/toplinks/search.gif\" alt=\"\" title=\"\" />{\$lang->toplinks_search}</a></li>");
}

function mygal_deactivate() {
	global $db;
	require MYBB_ROOT."/inc/adminfunctions_templates.php";
	find_replace_templatesets("header", '#					<li><a href="mygal.php">(.*)</li>\n#', '', 0);
}

function mygal_uninstall() {
	global $db;
	$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE name IN ('enablemygal','mygal_name','mygal_restrict', 'mygal_admin', 'mygal_h', 'mygal_w', 'mygal_order', 'mygal_order2', 'mygal_pics', 'mygal_upload', 'mygal_size', 'mygal_mycode', 'mygal_order3', 'mygal_order4', 'mygal_order5', 'mygal_page_pic', 'mygal_page_cat', 'mygal_page_comment', 'mygal_guests', 'mygal_post', 'mygal_classic', 'mygal_title', 'mygal_desc')");
	$db->query("DELETE FROM ".TABLE_PREFIX."settinggroups WHERE name='mygal'");
	rebuild_settings();
	$db->query("DROP TABLE ".TABLE_PREFIX."gallery_photos");
	$db->query("DROP TABLE ".TABLE_PREFIX."gallery_cats");
	$db->query("DROP TABLE ".TABLE_PREFIX."gallery_comments");
	$db->query("DROP TABLE ".TABLE_PREFIX."gallery_ratings");
}


?>